#include <cmath>

#include "EuclideanSquaredMetric.hpp"

double EuclideanSquaredMetric::distance(Point const & x, Point const & y) const
{
	if(x.getDimension() != y.getDimension())
		throw "Incompatible dimension";
	
	double dist = 0;
	int dim = x.getDimension();
	for(int i = 0; i < dim; ++i)
	{
		double tmp = x[i] - y[i];
		dist += tmp * tmp;
	}
	return dist;
}