#include <cmath>

#include "EuclideanMetric.hpp"

double EuclideanMetric::distance(Point const & x, Point const & y) const
{
	if(x.getDimension() != y.getDimension())
		throw "Incompatible dimension";
	
	double dist = 0;
	int dim = x.getDimension();
	for(int i = 0; i < dim; ++i)
	{
		double tmp = x[i] - y[i];
		dist += tmp * tmp;
	}
	dist = std::sqrt(dist);
	return dist;
}